### **实验名称**

消费者行为分析

### **实验目的**

1.掌握聚类算法的应用

2.使用聚类算法进行消费者行为分析

### **实验背景**

在大数据应用领域，经常会用聚类算法来分析客户偏好、习惯，以及消费行为，从而解决营销问题。 本次任务将利用一个包含消费者行为和消费特点的数据集，用聚类算法对其进行建模，对年龄与消费积分、年收入与消费积分两种不同的分类进行聚类分析，可以给商家向消费者采取针对性的营销手段提供数据参考。

### **实验原理**

聚类分析的目标就是在相似的基础上收集数据来分类。聚类源于很多领域，包括数学，计算机科学，统计学，生物学和经济学 。

### **实验环境**

Ubuntu 18.04

scikit-learn 0.18.1

scipy 0.19.1

### **建议课时**

4 课时

### **实验步骤**

环境准备：

获取数据集

```markup
cd ~
wget http://10.90.3.2/HUP/DataMining/2024/08/Mall_Customers.csv
```

双击打开桌面的“terminal”后，在命令行中输入如下命令，开启 jupyter notebook：

```python
jupyter notebook
```

打开 Jupter，点击右上角上的“New”按钮，选择“python3”创建文件。

![1721522453348.png](./pic/1721522453348.png)

#### 1\. 对数据集进行分析

在 Jupyter Notebook 中新建一个记事本文件，载入这个数据集，并且大致了解数据集中的特征。 **1\. 载入数据集并查看特征** 首先，我们需要把数据集下载到本地，再使用 Jupyter Notebook 将其载入，并且详细查看数据集中的特征情况。在 Jupyter Notebook 中输入代码如下：

```python
#载入 pandas
import pandas as pd
#使用pandas载入数据集，把路径替换为数据集存放路径
data = pd.read_csv('Mall_Customers.csv')
#显示数据集前5行
data.head()
```

运行代码，得到表 1 所示的结果。

![b1.png](./pic/b1.png)

从表 1 中我们可以看到，pandas 成功把数据集载入，并且成功显示了数据集的前 5 行。从中我们也可以看到这个数据集中有 5 个特征，分别是 CustomerID(客户编号)。 Gender（性别）、Age（年龄）、Annual Income（年收入），以及 Spending Score（消费积分）。其中年收入的单位是“k$（千美元）”，消费积分的范围是 1~100。 接下来，我们还要进一步了解数据集的情况。

**2\. 了解数据集的形态和各个特征的统计信息** 

在使用该数据集之前，需要大致了解数据集中的一些情况，如数据集中有多少条数据、各个特征中的数据都是什么类型等。在 Jupyter Notebook 中输入代码如下：

```python
#显示数据集的形态
data.shape
```

运行代码，得到的结果如下：

```markup
(200，5)
```

从上面的代码运行结果我们可以看到，这个数据集共有 200 条数据，每条数据的特征有 5 个，这和我们在前文中通过 data.headO 查看的数据特征数量是一致的。 接下来我们来了解数据集各个特征的简要统计信息，输入代码如下：

```python
#查看数据特征的统计信息
data.describe()
```

运行代码，得到表 2 所示的结果。

![b2.png](./pic/b2.png)

从表 2 中我们可以看到各特征的统计信息，说明如下： (1)“Age”这一列，最小值是 18.00，而最大值是 70.00，中位数是 36.00，平均值是 38.85，标准差为 13.97。 (2)“AnnualIncome”这一列，最小值是 2.63 万，最大值是 13.70 万，中位数是 6.15 万，而平均值是 6.06 万，标准差为 2.60 万。 (3)“Spending Score”中的最小值是 1.00，最大值是 99.00，中位数是 50.00，平均值是 50.20，标准差是 25.80。 到这里，大家可能发现，在数据集的统计信息中没有“Gender”这一列，那么我们如何知道消费者的性别分布情况呢?输入代码如下:

```python
# 查看消费者性别分布
data['Gender'].describe()
```

运行代码，得到如下的结果:

```markup
count        200
unique         2
top       Female
freq         112
Name: Gender, dtype: object
```

从代码的运行结果我们可以看到，在“Gender”这一列中，共有 200 条数据，其中包含 2 种不同的值，其中“Female(女性)”出现频率最高，达到 112 次，则“Male(男性)”出现了 88 次，说明数据集中女性消费者稍占多数。 现在我们再来看看数据集中每个特征的数据类型，以及是否包含空值。输入代码如下:

```python
# 查看各个特征的数据类型及是否包含空值
data.info()
```

运行代码，得到如下的结果:

```markup
<class 'pandas.core.frame.DataFrame'>
RangeIndex: 200 entries, 0 to 199
Data columns (total 5 columns):
CustomerID                200 non-null int64
Gender                    200 non-null object
Age                       200 non-null int64
Annual Income (k$)        200 non-null int64
Spending Score (1-100)    200 non-null int64
dtypes: int64(4), object(1)
memory usage: 7.9+ KB
```

从上面的结果中我们可以看出，各个特征都有 200 条数据，看来数据集中并没有空值，这就不需要对空值进行补全。同时，消费者的年龄、年收入和消费积分都是整数类型的数据，而性别特征则是字符串类型的数据。

#### 2 使用 K 均值算法进行聚类分析

现在我们已经对消费者的情况有了一定的了解，并且也得到了一些启发。在本小节中，我们就使用 K 均值算法对消费者进行聚类，看看他们大致可以分为几类。

**1.对年龄与消费积分进行聚类** 

现在我们就来对数据集中的消费者年龄和消费积分这两个特征进行聚类，看看消费者可以分为什么类型。在 JupyterNotebook 中输入代码如下:

```python
# 导入KMeans工具
from sklearn.cluster import KMeans
# 导入numpy
import numpy as np
# 导入pyplot
import matplotlib.pyplot as plt

# 首先，我们把数据集中的年龄和消费积分的值付给X1
X1 = data[['Age', 'Spending Score (1-100)']].iloc[:, :].values
# 定义一个空列表，用来装kmeans的inertia属性
# inertia属性表示数据集中样本表示样本到最近的聚类中心的距离总和。
# 值越小越好，越小表示样本在类间的分布越集中。
inertia = []
# 设置一个1-10的循环
for n in range(1, 11):
    # n_clusters = n 表示分别让kmeans把数据聚成1-10个类
    # 使用初始化优化“kMeans++”
    # “n_init”参数表示使用不同质心种子运行k均值算法的时间，
    # 最终结果将是n_init连续运行在惯性方面的最佳输出。
    # “max_iter”参数表示最大迭代次数
    # “tol”参数表示模型收敛惯性的相对公差
    # algorithm = ‘elkan’表示使用elkan变体，利用三角不等式，使算法更有效率。
    algorithm = (KMeans(n_clusters=n, init='k-means++', n_init=10, max_iter=300,
                        tol=0.0001,  random_state=111, algorithm='elkan'))
    # 用设置好的模型拟合X1
    algorithm.fit(X1)
    # 将不同聚类数对应的inertia属性添加到inertia列表中
    inertia.append(algorithm.inertia_)
# 接下来我们画个图，先定义下图像的尺寸
plt.figure(1, figsize=(15, 6))
# 绘制聚类中心数从1到10时的inertia值
plt.plot(np.arange(1, 11), inertia, 'o')
plt.plot(np.arange(1, 11), inertia, '-', alpha=0.5)
# 设置图像的x轴和y轴的标题
plt.xlabel('Number of Clusters', fontsize=14), plt.ylabel(
    'Inertia', fontsize=14)
# 显示图像
plt.show()
```

运行代码，得到图所示的结果:

![13.png](./pic/13.png)

不同的聚类中心数量对应的 inertia 值

从图中我们可以看到，随着聚类中心的数量越来越多，K 均值的 inertia 值越来越小。为了保持聚类簇合理的个数，我们需要选择一个折中的办法，一般情况下聚类的个数可以参考使用 inertia 值下降速度开始明显变缓时对应的聚类中心的数量。从图 9.13 中，可以初步判断聚类中心的数量大于 4 的时候，inertia 值下降的速度明显变小了。那么使用年龄和消费积分这两个特征进行聚类时，nclusters 等于 4 就是不错的选择得 nclusters 参数的值后，可以开始进行聚类了，输入代码如下:

```python
# 定义K均值算法的n_clusters参数为4，其它参数保持和前面一样即可
algorithm = (KMeans(n_clusters=4, init='k-means++', n_init=10, max_iter=300,
                    tol=0.0001,  random_state=111, algorithm='elkan'))
# 用模型拟合X1
algorithm.fit(X1)
# 把模型的labels属性赋给labels1
labels1 = algorithm.labels_
# 把模型的聚类中心cluster_centers属性赋值给centroids1
centroids1 = algorithm.cluster_centers_
# 下面的代码是用来绘图的，这里我们不展开解释
h = 0.02
x_min, x_max = X1[:, 0].min() - 1, X1[:, 0].max() + 1
y_min, y_max = X1[:, 1].min() - 1, X1[:, 1].max() + 1
xx, yy = np.meshgrid(np.arange(x_min, x_max, h), np.arange(y_min, y_max, h))
Z = algorithm.predict(np.c_[xx.ravel(), yy.ravel()])

plt.figure(1, figsize=(15, 7))
plt.clf()
Z = Z.reshape(xx.shape)
plt.imshow(Z, interpolation='nearest',
           extent=(xx.min(), xx.max(), yy.min(), yy.max()),
           cmap=plt.cm.Pastel2, aspect='auto', origin='lower')

plt.scatter(x='Age', y='Spending Score (1-100)', data=data, c=labels1,
            s=200)
plt.scatter(x=centroids1[:, 0], y=centroids1[:, 1],
            s=300, c='red', alpha=0.5, marker='*', linewidths=3)
plt.ylabel('Spending Score (1-100)',
           fontsize=20), plt.xlabel('Age', fontsize=20)
# 显示图像
plt.show()
```

运行结果如下所示：（根据不同的库版本，图形着色有些许差异）

![14.png](./pic/14.png)

对年龄和消费积分进行聚类

上图比较完美地解释了 K 均值算法的原理--对于给定的数据集,按照样本之间的距离大小，将数据集划分为 k 个簇。让簇内的点尽量紧密地连在一起，而让间的距离尽量的大。这里我们就把数据集分成了 4 个。图 14 中每个簇中间位置的五角星代表的就是每个簇的中心。这 4 个代表了 4 个类型的消费者。

*   左上角的簇代表年龄稍小但消费能力强的人群，我们可以称之为“富二代”群。
*   中间靠左的簇代表年龄稍小但消费能力中等的人群，我们可以称之为“中产青年”群。
*   中间靠右的簇代表年龄稍大且消费能力中等的人群，我们可以称之为“理性中年消费者”群。
*   最下面这一簇代表无论年龄长幼都很节俭的人群,我们可以称之为“勤俭持家”群.

这样我们就给不同年龄阶段及消费能力的消费者打上了标签。

**2.对年收入与消费积分进行聚类** 

前文我们通过年龄和消费积分找到了 4 种类型的消费者，下面我们再试试看，是不是可以从消费者的年收入和消费积分中找到消费者的其他类型。首先需要寻找合适的 n\_clusters 参数，输入代码如下:

```python
# 将消费者的年收入和消费积分赋给X2
X2 = data[['Annual Income (k$)', 'Spending Score (1-100)']].iloc[:, :].values
# 还是定义空列表，来存储inertia属性
inertia = []
# 同样是让n从1-10取值
for n in range(1, 11):
    # K均值各项参数设置和之前相同，我们这里不赘述了
    algorithm = (KMeans(n_clusters=n, init='k-means++', n_init=10, max_iter=300,
                        tol=0.0001,  random_state=111, algorithm='elkan'))
    # 用模型拟合X2
    algorithm.fit(X2)
    # 把模型的inertia属性添加到空列表中
    inertia.append(algorithm.inertia_)
# 画图的方法也和之前一致，也不赘述了
plt.figure(1, figsize=(15, 6))
plt.plot(np.arange(1, 11), inertia, 'o')
plt.plot(np.arange(1, 11), inertia, '-', alpha=0.5)
plt.xlabel('Number of Clusters'), plt.ylabel('Inertia')
# 显示图像
plt.show()
```

运行代码，得到图所示的结果:

![15.png](./pic/15.png)

同样的思路，我们要选择一个合适的聚类中心数量。在图 9.15 中我们看到，当 n\_clusters 大于 5 的时候，惯性的数值下降的幅度显著变小了。也就是说，n\_clusters 为 5 是一个比较合适的聚类中心的数量。 既然我们找到了合适的聚类，下面就可以进行聚类了。输入代码如下:

```python
# 设置K均值的n_clusters参数为5，其它参数保持不变
algorithm = (KMeans(n_clusters=5, init='k-means++', n_init=10, max_iter=300,
                    tol=0.0001,  random_state=111, algorithm='elkan'))
# 用模型拟合X2
algorithm.fit(X2)
# 获取模型的labels属性
labels2 = algorithm.labels_
# 获取模型的cluster_centers属性
centroids2 = algorithm.cluster_centers_
# 下面的图像用于绘图，不详细注释了
h = 0.02
x_min, x_max = X2[:, 0].min() - 1, X2[:, 0].max() + 1
y_min, y_max = X2[:, 1].min() - 1, X2[:, 1].max() + 1
xx, yy = np.meshgrid(np.arange(x_min, x_max, h), np.arange(y_min, y_max, h))
Z2 = algorithm.predict(np.c_[xx.ravel(), yy.ravel()])
plt.figure(1, figsize=(15, 7))
plt.clf()
Z2 = Z2.reshape(xx.shape)
plt.imshow(Z2, interpolation='nearest',
           extent=(xx.min(), xx.max(), yy.min(), yy.max()),
           cmap=plt.cm.Pastel2, aspect='auto', origin='lower')

plt.scatter(x='Annual Income (k$)', y='Spending Score (1-100)',
            data=data, c=labels2,
            s=200)
plt.scatter(x=centroids2[:, 0], y=centroids2[:, 1],
            s=300, c='red', alpha=0.5, marker='*', linewidths=3)
plt.ylabel('Spending Score (1-100)', fontsize=20)
plt.xlabel('Annual Income (k$)', fontsize=20)
# 显示图像
plt.show()
```

运行代码，得到下图所示的结果。（根据不同的库版本，图形着色有些许差异）

![16.png](./pic/16.png)

对年收入和消费积分进行聚类

从图中我们可以看到,K 均值算法根据消费者的年收入和消费积分将消费者分成了 5 个类型。

*   左上角代表收入低但消费高的人群，就是所谓的“月光族”
*   右上角代表收入高消费也高的人群，可以称之为“社会精英”
*   左下角代表收入少消费也低的人群，属于“贫困户”。
*   右下角代表收入高但消费低的人群，估计就是“理财大户”
*   中间的一簇，收入、消费能力都是中等，按“普通消费者”的标签进行分类就 可以。

### **实验总结**

(1)聚类算法是一种无监督学习的算法，它与监督学习的分类和回归算法的主要不 同点在于它不需要样本携带标签。 (2)常用的聚类算法有两种，分别是 K 均值算法和 DBSCAN 算法。 (3)K 均值算法是一种迭代求解的算法，它接受一个未标记的数据集，并将每个数据样本聚集到其最近距离均值的类中。